#pragma once
#include "Model.h"
#include "SpotLight.h"
#include "Vector3.h"

class SlotMachine : public Model
{
	public:
		SlotMachine();
		~SlotMachine();

		//Overrides
		bool loadMTL(char* modelFilename, char* mtlFilename, int renderingShape = GL_TRIANGLES) override;
		void render(Vector3 position = Vector3(13.0f, 1.0f, -1.5f)) override;

		void Update(float dt);	//Update, for updating win flash progress
		void SetLights(SpotLight* win);	//Set light for _GreenWinLight
		void Activate();	//Activates rotation and win light

	private:
		Model _SlotWheels[3];	//Spinners
		SpotLight* _GreenWinLight;	//Pointer to win light
		float _Rotation;	//Rotation variable for spinners

		bool _CurrentlyActivated = false;	//Machine currently animating
		bool _DoneRotating = false;	//Whether the spinners are finished
		bool _FlashingWin = false;	//Whether the light is flashing
};

